<?php
/*
Plugin Name: Customise wp-login
Description: Custom functions for customising the wp-login page
Version: 1.0.0
Author: IT Support Guides
Author URI: itsupportguides.com
*/

// START Add HTML
add_action( 'login_head', 'my_custom_login_head' );
function my_custom_login_head() {
     $html = '<span style="font-weight:800;font-size:20px;color:red;">[login_head]</span>';
	 echo $html;
}

add_action( 'login_form', 'my_custom_login_form' );
function my_custom_login_form() {
     $html = '<span style="font-weight:800;font-size:20px;color:red;">[login_form]</span>';
	 echo $html;
}

add_action( 'login_footer', 'my_custom_login_footer' );
function my_custom_login_footer() {
     $html = '<span style="font-weight:800;font-size:20px;color:red;">[login_footer]</span>';
	 echo $html;
}
// END Add HTML

// START Add style sheet
add_action( 'login_enqueue_scripts', 'my_custom_login_enqueue_scripts' );
function my_custom_login_enqueue_scripts() {
    wp_enqueue_style( 'my-custom-login', get_stylesheet_directory_uri() . '/style.css' );
}
// END Add style sheet

// START Customise logo
// NOTE - It is recommended you customise the logo using CSS in your style sheet - below provided as a working example using inline styles
add_action( 'login_enqueue_scripts', 'my_custom_login_enqueue_scripts_inline' );
function my_custom_login_enqueue_scripts_inline() { ?>
    <style>
        #login h1 a {
            background: url(data:image/jpeg;base64,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) no-repeat;
			height: 150px;
			width: 150px;
        }
    </style>
<?php }

add_filter( 'login_headerurl', 'my_custom_login_headerurl' );
function my_custom_login_headerurl() {
    return home_url();
}

add_filter( 'login_headertitle', 'my_custom_login_headertitle' );
function my_custom_login_headertitle() {
    return 'IT Support Guides';
}
// END Customise logo

// START Customise text
add_filter( 'gettext', 'my_custom_gettext', 20, 3 );
function my_custom_gettext( $translated_text, $text, $domain ) {
	if ( 'wp-login.php' === $GLOBALS['pagenow'] ) {
		if ( "Lost your password?" == $translated_text )
			$translated_text = __( 'Forgot your password?' );
		elseif ( "Username or Email Address" == $translated_text )
			$translated_text = __( 'Email address');
		else if ( "Check your email for the confirmation link." == $translated_text )
			$translated_text = __( 'An email has been sent to the given email address. Please check your email and follow the instructions to reset your password.' );
		else if ( "Please enter your username or email address. You will receive a link to create a new password via email." == $translated_text )
			$translated_text = __( 'Please enter the email address registered with this website. You will receive an email with instructions on changing your password.' );
	}
    return $translated_text;
}
// END Customise text

// START Disable random password
add_filter( 'random_password', 'my_custom_random_password', 10, 2 );
function my_custom_random_password( $password ) {
	$action = isset( $_GET['action'] ) ? $_GET['action'] : '';
	if ( 'wp-login.php' === $GLOBALS['pagenow'] && ( 'rp' == $action  || 'resetpass' == $action ) ) {
		return '';
	}
	return $password;
}
// END Disable random password

// START Customise password reset email
add_filter( 'retrieve_password_title', 'my_custom_retrieve_password_title', 10, 3 );
function my_custom_retrieve_password_title( $title, $user_login, $user_data ) {
	return sprintf( __( "Password reset for %s" ), $user_login );
}

add_filter( 'retrieve_password_message', 'my_custom_retrieve_password_message', 10, 4 );
function my_custom_retrieve_password_message( $message, $key, $user_login, $user_data ) {
    $message = __('A password reset has been requested for an account with the following username:') . "\r\n\r\n";
	$message .= $user_login . "\r\n\r\n";
	$message .= __('Please click on the link below to reset your password. If you are unable to click the link, copy it to your browser and press enter to reset your password.') . "\r\n\r\n";
	$message .= network_site_url("wp-login.php?action=rp&key=$key&login=" . rawurlencode($user_login), 'login') . "\r\n\r\n";
	$message .= __('If you did not request a password reset or it is no longer required, please ignore this email.') . "\r\n\r\n";

    return $message; 
}
// END Customise password reset email